// // // // // // // // // // // // // // // //
//
//	Enemy Territory - Karte.cc
//
//	created November 5th,97 by Andreas Warnke
//	geändert 6.5.98 von Andreas Warnke
//



#include "Karte.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor
//
//	SpielFeld:
//	Anordnung der Felder:
//	
//	0	  [ ] [ ] [2] [3] [4] [5] [6] [ ] [ ]
//	1	[ ] [ ] [2] [3] [4] [5] [6] [7] [ ]
//	2	  [ ] [1] [2] [3] [4] [5] [6] [7] [ ]
//	3	[ ] [1] [2] [3] [4] [5] [6] [7] [8] 
//	4	  [0] [1] [2] [3] [4] [5] [6] [7] [8]
//	5	[ ] [1] [2] [3] [4] [5] [6] [7] [8]
//	6	  [ ] [1] [2] [3] [4] [5] [6] [7] [ ]
//	7	[ ] [ ] [2] [3] [4] [5] [6] [7] [ ]
//	8	  [ ] [ ] [2] [3] [4] [5] [6] [ ] [ ]
//	
//	0	  [ ] [1] [2] [3] [4] [ ] [ ] 
//	1	[ ] [1] [2] [3] [4] [5] [ ] 
//	2	  [0] [1] [2] [3] [4] [5] [ ]
//	3	[0] [1] [2] [3] [4] [5] [6]  
//	4	  [0] [1] [2] [3] [4] [5] [ ]
//	5	[ ] [1] [2] [3] [4] [5] [ ] 
//	6	  [ ] [1] [2] [3] [4] [ ] [ ] 
//
	
Karte :: Karte ( int inSize )
{
	//	Berechnen der Breite und höhe:
	Height = inSize * 2 - 1 ;
	if ( Height < 0 )
		Height = 0;
	Width = Height;
	
	//	Allokieren des Speichers:
	if ( Height == 0 )
		Feld = NULL;
	else
		Feld = new ( uint8 [ Width * Height ] );
	
	//	Out of memory?
	if ( Feld == NULL )
	{
		Width = 0;
		Height = 0;
	}
	else
	{
		//	Initialisieren des Feldes mit einem
		//	von EndOfWold verschiedenen Wert:
		for ( int i = 0; i < Width*Height; i++)
			Feld [ i ] = FT_Undiscovered;
	};
	
	//	Symmetrie-Achsen:
	float AxisY = ( Height - 1 ) / 2.0;
	float AxisX = ( Width - 1 ) / 2.0;
	if ( IsShiftRight ( int ( AxisY ) ) )
		AxisX = AxisX + 0.5;
	
	//	Initialisieren des Feldes:
	for ( int x = 0; x < Width; x++ )
		for ( int y = 0; y < Height; y++ )
		{
			//	Achsenspiegelungen,
			//	so daß die Position im Quadrant oben links ist:
			float MirrorX = x + 0.5 * IsShiftRight ( y );
			float MirrorY = y;
			if ( MirrorY > AxisY )
				MirrorY = ( Height - 1 ) - MirrorY;
			if ( MirrorX > AxisX )
				MirrorX = ( 2 * AxisX ) - MirrorX;
				
			//	Ist MirrorX * 2 < AxisY - MirrorY 
			//	so ist das Feld nicht auf den Spielfeld:
			if ( 2.0 * MirrorX + 0.0001 < AxisY - MirrorY )
				SetFieldType ( x, y, FT_EndOfWorld );
			else
				SetFieldType ( x, y, FT_Undiscovered );
		};
};



// // // // // // // // // // // // // // // //
//
//	Destruktor
//

Karte :: ~Karte ()
{
	//	Freigeben des belegten Speichers:
	if ( Feld != NULL )
	{
		delete [] Feld;
		Feld = NULL;
		Height = 0;
		Width = 0;
	};
};



// // // // // // // // // // // // // // // //
//
//	GetFieldType
//

uint8 Karte :: GetFieldType ( int x, int y )
{
	if ( ( x >= 0 ) && ( x < Width ) && ( y >= 0 ) && ( y < Height ) )
		return ( Feld [ y * Width + x ] );
	else
		return ( FT_EndOfWorld );
};



// // // // // // // // // // // // // // // //
//
//	SetFieldType
//

void Karte :: SetFieldType ( int x, int y, uint8 NewValue )
{
	if ( GetFieldType ( x, y ) != FT_EndOfWorld )
		Feld [ y * Width + x ] = NewValue;
};



// // // // // // // // // // // // // // // //
//
//	GetFieldViscosity	
//

bigtime_t Karte :: GetFieldDelay ( int inType )
{
	int sRealType = ( inType & FT_TypeMask );
/*	if (( FT_Plain <= sRealType ) && ( sRealType < FT_Plain + FI_Plain ))
		return ( FD_Plain );
	if (( FT_Forrest <= sRealType ) && ( sRealType < FT_Forrest + FI_Forrest ))
		return ( FD_Forrest );
	if (( FT_Mountain <= sRealType ) && ( sRealType < FT_Mountain + FI_Mountain ))
		return ( FD_Mountain );
	if (( FT_Sea <= sRealType ) && ( sRealType < FT_Sea + FI_Sea ))
		return ( FD_Sea );
	if ( FT_Invisible == sRealType )
		return ( FD_Invisible );
	if ( FT_Undiscovered == sRealType ) 
		return ( FD_Undiscovered );
	else
		return ( FD_EndOfWorld );*/
	if ( sRealType >= FT_Plain )
		if ( sRealType >= FT_Mountain )
			return FD_Mountain;
		else
			if ( sRealType >= FT_Forrest )
				return FD_Forrest;
			else
				return FD_Plain;
	else
		if ( sRealType >= FT_Undiscovered )
			if ( sRealType >= FT_Sea )
				return FD_Sea;
			else
				return FD_Undiscovered;
		else
			if ( sRealType >= FT_Invisible )
				return FD_Invisible;
			else
				return FD_EndOfWorld;
};



// // // // // // // // // // // // // // // //
//
//	GetFieldViscosity
//

bigtime_t Karte :: GetFieldDelay ( int x, int y )
{
	return ( GetFieldDelay ( GetFieldType ( x, y ) ) );
};



// // // // // // // // // // // // // // // //
//
//	GetWidth
//

int Karte :: GetWidth ()
{
	return Width;
};



// // // // // // // // // // // // // // // //
//
//	GetHeigth
//

int Karte :: GetHeight ()
{
	return Height;
};



// // // // // // // // // // // // // // // //
//
//	IsShiftRight
//

int Karte :: IsShiftRight ( int inRow )
{
	//	inRow gerade ?
	return ( ( inRow & 1 ) == 0 );
};



// // // // // // // // // // // // // // // //
//
//	Distance
//

unsigned int Karte :: Distance ( int inX1, int inY1, int inX2, int inY2)
{
	//	Skalieren der Koordinaten:
	inX1 = inX1 * 2 + IsShiftRight ( inY1 );
	inX2 = inX2 * 2 + IsShiftRight ( inY2 );
	
	//	Bild:
	//	[]  []  []  []  [] ...
	//	  []  []  []  []  [] ...
	//	[]  []  []  []  [] ...
	//	 :
	//	 :
	
	//	X-Abstand:
	int dx;
	if ( inX1 < inX2 )
		dx = inX2 - inX1;
	else
		dx = inX1 - inX2;
		
	//	Y-Abstand:
	int dy;
	if ( inY1 < inY2 )
		dy = inY2 - inY1;
	else
		dy = inY1 - inY2;
		
	//	vom X-Abstand kann ich den Y-Abstand abziehen,
	//	dx ist dann eine gerade Zahl:
	dx = dx - dy;
	
	if ( dx < 0 )
		//	nur der y-Abstand ist relevant:
		return dy;
	else
		//	y- und Rest-x-Abstand sind relevant.
		return dy + ( dx / 2 );
};



// // // // // // // // // // // // // // // //
//
//	GetFieldViewCost
//

int Karte :: GetFieldViewCost ( int inType )
{
	int sRealType = ( inType & FT_TypeMask );
/*	if ( ( FT_Plain <= sRealType ) && ( sRealType < FT_Plain + FI_Plain ) )
		return ( FV_Plain );
	if ( ( FT_Forrest <= sRealType ) && ( sRealType < FT_Forrest + FI_Forrest ) )
		return ( FV_Forrest );
	if ( ( FT_Sea <= sRealType ) && ( sRealType < FT_Sea + FI_Sea ) )
		return ( FV_Sea );
	if ( ( FT_Mountain <= sRealType ) && ( sRealType < FT_Mountain + FI_Mountain ) )
		return ( FV_Mountain );
	if ( FT_Invisible <= sRealType ) 
		return ( FV_Invisible );
	if ( FT_Undiscovered == sRealType )
		return ( FV_Undiscovered );
	else
		return ( FV_EndOfWorld );*/
	if ( sRealType >= FT_Plain )
		if ( sRealType >= FT_Mountain )
			return FV_Mountain;
		else
			if ( sRealType >= FT_Forrest )
				return FV_Forrest;
			else
				return FV_Plain;
	else
		if ( sRealType >= FT_Undiscovered )
			if ( sRealType >= FT_Sea )
				return FV_Sea;
			else
				return FV_Undiscovered;
		else
			if ( sRealType >= FT_Invisible )
				return FV_Invisible;
			else
				return FV_EndOfWorld;
};



// // // // // // // // // // // // // // // //
//
//	GetFieldViewCost
//

int Karte :: GetFieldViewCost ( int x, int y )
{
	return GetFieldViewCost ( GetFieldType ( x, y ) );
};



//
//	Ende.
//
// // // // // // // // // // // // // // // //